/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.config;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.config.ConfigFile;
import Krasnodar.rockstarnew.systems.config.ConfigManager;
import Krasnodar.rockstarnew.systems.file.FileManager;
import Krasnodar.rockstarnew.systems.notifications.NotificationType;
import Krasnodar.rockstarnew.utility.game.MessageUtility;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import lombok.Generated;
import net.minecraft.class_2561;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWDropCallbackI;
import ru.kotopushka.compiler.sdk.annotations.Compile;
import ru.kotopushka.compiler.sdk.annotations.Initialization;

public final class ConfigDropHandler
implements IMinecraft {
    private static boolean initialized;

    @Compile
    @Initialization
    public static void init() {
        if (!initialized) {
            initialized = true;
            long handle = mc.method_22683().method_4490();
            GLFWDropCallbackI[] previous = new GLFWDropCallbackI[1];
            GLFWDropCallbackI callback = (window, count, names) -> {
                if (previous[0] != null) {
                    previous[0].invoke(window, count, names);
                }
                for (int i = 0; i < count; ++i) {
                    String path = GLFWDropCallback.getName((long)names, (int)i);
                    ConfigDropHandler.handleDrop(path);
                }
            };
            previous[0] = GLFW.glfwSetDropCallback((long)handle, (GLFWDropCallbackI)callback);
        }
    }

    private static void handleDrop(String path) {
        try {
            File src = new File(path);
            if (!src.isFile()) {
                return;
            }
            if (!src.getName().endsWith(".rock")) {
                return;
            }
            File destDir = new File(FileManager.DIRECTORY, "configs");
            if (!destDir.exists() && !destDir.mkdirs()) {
                Rockstar.LOGGER.error("Failed to create directory {}", (Object)destDir.getAbsolutePath());
                return;
            }
            File dest = new File(destDir, src.getName());
            Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            String name = src.getName().substring(0, src.getName().lastIndexOf(46));
            ConfigManager manager = Rockstar.getInstance().getConfigManager();
            manager.refresh();
            ConfigFile cfg = manager.getConfig(name);
            if (cfg == null) {
                cfg = new ConfigFile(name);
                manager.getConfigFiles().add(cfg);
            }
            cfg.load();
            MessageUtility.info(class_2561.method_30163((String)("\u041a\u043e\u043d\u0444\u0438\u0433 " + name + " \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d")));
            Rockstar.getInstance().getNotificationManager().addNotification(NotificationType.SUCCESS, class_2561.method_43471((String)"configs.loaded").getString());
        }
        catch (Exception var7) {
            Rockstar.LOGGER.error("Failed to load dropped config {}", (Object)path, (Object)var7);
        }
    }

    @Generated
    private ConfigDropHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

